/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Michalik / ADIT/SW2 / jmichalik@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include "AilAudioOut.h"
#include "AilAudioIn.h"
#include "AilConfiguration.h"

LOG_DECLARE_CONTEXT(cply);

using namespace adit::carplay;

extern "C" void carplay_LibraryEntryPoint()
{
    // register ail at logging
    LOG_REGISTER_CONTEXT(cply, "CALS", "CarPlay AIL audio");
    LOGD_DEBUG((cply, "carplay-ail git tag: %s", COMP_GIT_VERSION));
    (void)AilConfiguration::Instance();

    carplay_FactoryRegister<IAudioOutAdapter, AilAudioOut>("AilAudioOut");
    carplay_FactoryRegister<IAudioInAdapter, AilAudioIn>("AilAudioIn");
}

extern "C" void carplay_LibraryExitPoint()
{
    LOG_UNREGISTER_CONTEXT(cply);
}
